/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package export;

//import java.awt.BorderLayout;
//import java.awt.Color;
import javax.swing.JFrame;
import com.inet.viewer.ReportView;
import com.inet.viewer.SwingReportViewer;
import com.inet.viewer.URLRenderData;

/**
 * This sample shows you how you can export a report using the Java report viewer API with or without the report preview
 * in the Java report viewer, using the method ReportView.export( String exportFormat, String fileName ).
 */
public class ExportWithViewer extends JFrame {

    /**
     * Initializes and runs an export with the given paths.
     * @param reportPath path of report to export
     * @param exportPath path of file to export into
     */
    public ExportWithViewer( String reportPath, String exportPath ) {
        try {

            // Initialize the viewer, add a report view connected to the URL of a report.
            URLRenderData renderData = new URLRenderData( "http://localhost:9000/?report=file:" + reportPath );
            SwingReportViewer viewer = new SwingReportViewer();
            ReportView view = viewer.addNewReportView( renderData );

            // Export report to desired file            
            view.export( ReportView.EXPORT_PDF, exportPath );

            // You need the following lines only if you would like to
            // display the report preview on the screen:
            /*
            setBounds(0,0,700,550);
            setBackground(Color.lightGray);
            getContentPane().setLayout(new BorderLayout());
            getContentPane().add(viewer.getComponent());
            setVisible(true);
            */
        } catch( Exception e ) {
            e.printStackTrace();
        }
    }

    /**
     * Main method of the sample.
     * @param args first parameter: report file, second parameter: file to export file
     * @throws Exception if there are IO issues or other problems
     */
    public static void main( String[] args ) throws Exception {
        if( args == null || args.length != 2 ) {
            System.out.println( "Usage: ExportWithViewer <Report File> <Export File>" );
            System.exit( 1 );
        }
        ExportWithViewer f = new ExportWithViewer( args[0], args[1] );

        // You need the following lines only if you would like to
        // display the report preview on the screen:
        /*
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setVisible(true);
        */
    }
}
